/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.auiml.databeans.ucode;

import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsBean;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsButtonHandlerTask;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsClientData;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsData;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsExt;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyResultsUtils;
import com.ibm.hsc.auiml.databeans.ucode.IOSurveyRunSurveyTask;
import com.ibm.hsc.auiml.databeans.ucode.RepositoryItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceItem;
import com.ibm.hsc.auiml.databeans.ucode.ResourceList;
import com.ibm.hsc.auiml.databeans.ucode.SurveyFileResult;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyDownload;
import com.ibm.hsc.auiml.databeans.ucode.UcodeSurveyException;
import com.ibm.hsc.common.bundles.HSCResourceBundleUtil;
import com.ibm.hsc.common.util.HSCLocalizableMsg;
import com.ibm.hsc.common.util.HSCPanelTasklet;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.websm.updates.UpdateWizardTasklet;
import com.ibm.hwmca.fw.tasklet.PanelBean;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.ui.framework.Capabilities;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class IOSurveyResultsTasklet
extends HSCPanelTasklet {
    public static final int PARTID_COLUMN = 0;
    public static final int ACT_COLUMN = 1;
    public static final int RES_COLUMN = 2;
    public static final int MACHINE_COLUMN = 3;
    public static final int MTMS_COLUMN = 4;
    public static final int ILVL_COLUMN = 5;
    public static final int RLVL_COLUMN = 6;
    public static final int IMPACT_COLUMN = 7;
    public static final int SUGGEST_COLUMN = 8;
    public static final int NUM_COLUMNS = 9;
    public static final String RESOURCE_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "RESOURCE_VALUE", "Logical Device");
    public static final String MTMS_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "MTMS_VALUE", "MTMS");
    public static final String MACHINE_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "MACHINE_VALUE", "Device");
    public static final String SUGGESTED_VALUE = HSCResourceBundleUtil.getMessage("UcodeBundle", "SUGGESTED_VALUE", "Suggested");
    public static final String CONFIRM_ALL = HSCResourceBundleUtil.getMessage("UcodeBundle", "UPDATE_CONFIRM_ALL", "ALL Selected");
    public static final String COLUMN_RESOURCE = "LogicalDevice";
    public static final String COLUMN_MTMS = "MTMSNumber";
    public static final String COLUMN_MACHINE = "DeviceName";
    public static final String COLUMN_SUGGESTED = "SuggestedAction";
    public static final String CHECKED = "TRUE";
    public static final String UNCHECKED = "FALSE";
    public static final String SORTABLE = "TRUE";
    public static final String UNSORTABLE = "FALSE";
    public static final String ENABLED = "YES";
    public static final String DISABLED = "NO";
    public static final String SERVICE_LEVEL = "ServiceLevel";
    public static final String SORT_BOX = "SortBy";
    public static final String RESOURCE_TABLE = "SurveyResponseTable";
    public static final String AUTO = "Auto";
    public static final String NOT_FOUND = SurveyFileResult.notFound;
    private static final String HTMLUlineBegin = "<html> <B>";
    private static final String HTMLUlineEnd = "</B> </html>";
    private static final String TRACE_MASKD = "JUCODECD";
    private static final String TRACE_MASKF = "JUCODECF";
    private static final String TRACE_MASKT = "JUCODECT";
    public static boolean viewInfoError = false;
    IOSurveyResultsData resultsData;
    IOSurveyResultsClientData clientData;
    IOSurveyResultsButtonHandlerTask buttonHandler;
    protected SurveyFileResult[] inSurveyFile = null;
    boolean currentSystemLevel = true;
    final String RESULTS_BEAN = "IO Results Bean";
    private String m_sReposLocation;
    private PanelHandler resultsPanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse, PanelTasklet panelTasklet) throws TaskletException {
            if (1 <= Trace.LEVEL) {
                Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "-> IOSurveyResultsTasklet.resultsPanelHandler.service()");
            }
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "dispose or cancel specified");
                }
                panelTaskletResponse.terminate();
            } else {
                TaskActionEvent taskActionEvent = (TaskActionEvent)panelTaskletRequest.getData("event");
                if (taskActionEvent.getElementName().equals("Cancel")) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "event from panel was Cancel");
                    }
                    panelTaskletResponse.terminate();
                } else {
                    IOSurveyResultsTasklet.this.showBusyDialog(new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "CHANGE_INT_CODE_TITLE"), new LocalizableText("com.ibm.hsc.common.bundles.UpdatesBundle", "PLEASE_WAIT"));
                    IOSurveyResultsTasklet.this.buttonHandler = new IOSurveyResultsButtonHandlerTask(IOSurveyResultsTasklet.this.resultsData);
                    if (taskActionEvent.getElementName().equals("OK")) {
                        if (1 <= Trace.LEVEL) {
                            Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "event from panel was Ok");
                        }
                        panelTaskletResponse = IOSurveyResultsTasklet.this.buttonHandler.setResourcesChecked(panelTaskletRequest, panelTaskletResponse);
                        IOSurveyResultsTasklet.this.resultsData.getResources().userModified = true;
                        PanelTasklet panelTasklet2 = panelTasklet.getParent();
                        if (panelTasklet2 instanceof UpdateWizardTasklet) {
                            if (3 <= Trace.LEVEL) {
                                Trace.trace(IOSurveyResultsTasklet.TRACE_MASKD, "resultsPanelHandler() parent is UpdateWizardTasklet");
                                Trace.trace(IOSurveyResultsTasklet.TRACE_MASKD, "resultsPanelHandler() update resource list to: " + IOSurveyResultsTasklet.this.resultsData.getResources());
                            }
                            ((UpdateWizardTasklet)panelTasklet2).setUpdatedResourceList(IOSurveyResultsTasklet.this.resultsData.getResources());
                        }
                        IOSurveyResultsTasklet.this.destroyBusyDialog();
                        panelTaskletResponse.terminate();
                    }
                    if (taskActionEvent.getElementName().equals("ViewInfo")) {
                        panelTaskletResponse = IOSurveyResultsTasklet.this.buttonHandler.viewInfo(panelTaskletRequest, panelTaskletResponse);
                        IOSurveyResultsTasklet.this.destroyBusyDialog();
                        if (!viewInfoError) {
                            IOSurveyResultsTasklet.this.currentPanel = IOSurveyResultsTasklet.this.devicePanelHandler;
                        }
                    }
                }
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "<- IOSurveyResultsTasklet.resultsPanelHandler.service()");
            }
        }
    };
    private PanelHandler devicePanelHandler = new PanelHandler(){

        public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse, PanelTasklet panelTasklet) throws TaskletException {
            if (1 <= Trace.LEVEL) {
                Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "-> IOSurveyResultsTasklet.devicePanelHandler.service()");
            }
            IOSurveyResultsTasklet.this.currentPanel = IOSurveyResultsTasklet.this.resultsPanelHandler;
            if (panelTaskletRequest.isDisposed() || panelTaskletRequest.isCanceled()) {
                if (1 <= Trace.LEVEL) {
                    Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "dispose of cancel specified");
                }
            } else {
                TaskActionEvent taskActionEvent = (TaskActionEvent)panelTaskletRequest.getData("event");
                if (taskActionEvent.getElementName().equals("Cancel")) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "event from panel was Cancel");
                    }
                } else if (panelTaskletRequest.getData("ButtonPressed").equals("OK")) {
                    IOSurveyResultsTasklet.this.resultsData.setDevicePanelButtonPressed("OK");
                } else {
                    IOSurveyResultsTasklet.this.resultsData.setDevicePanelButtonPressed("CancelUpdate");
                }
            }
            panelTaskletResponse.dispose();
            if (1 <= Trace.LEVEL) {
                Trace.trace(IOSurveyResultsTasklet.TRACE_MASKT, "<- IOSurveyResultsTasklet.devicePanelHandler.service()");
            }
        }
    };
    private PanelHandler currentPanel = this.resultsPanelHandler;

    public IOSurveyResultsTasklet() {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsTasklet()");
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsTasklet()");
        }
    }

    public void logException(Throwable throwable) {
    }

    public void init() throws TaskletException {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<->IOSurveyResultsTasklet.init() redirect data = '" + this.getRedirectData() + "'");
        }
        super.init();
    }

    public void service(PanelTaskletRequest panelTaskletRequest, PanelTaskletResponse panelTaskletResponse) throws TaskletException {
        if (panelTaskletRequest.isInitialRequest()) {
            Object object;
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "IOSurveyResultsTasklet.service() (initial request) ptp= '" + this.presentationTaskParms + "'");
                Trace.trace(TRACE_MASKD, "IOSurveyResultsTasklet.service() (initial request) req-data= '" + panelTaskletRequest.getDataMap() + "'");
            }
            Map map = new HashMap();
            map = panelTaskletRequest.getDataMap();
            RepositoryItem repositoryItem = (RepositoryItem)map.get("repos");
            ArrayList arrayList = (ArrayList)map.get("targets");
            ResourceList resourceList = (ResourceList)map.get("survey");
            String string = (String)map.get("readonly");
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Repository = " + repositoryItem);
                if (arrayList == null) {
                    Trace.trace(TRACE_MASKD, "Target #1 = null");
                } else {
                    Trace.trace(TRACE_MASKD, "Target #1 = " + ((ResourceItem)arrayList.get(0)).getMTMS());
                }
                Trace.trace(TRACE_MASKD, "ReadOnly = " + string);
            }
            this.resultsData = new IOSurveyResultsData();
            this.resultsData.setIOSurveyTasklet(this);
            this.resultsData.setReposLevel(repositoryItem);
            this.resultsData.setTargets(arrayList);
            this.resultsData.setIODownload(new UcodeSurveyDownload(this.resultsData));
            this.resultsData.setIOResultsExt(new IOSurveyResultsExt(this.resultsData));
            this.resultsData.setIOUtils(new IOSurveyResultsUtils());
            this.resultsData.setTaskletInterface(true);
            try {
                this.resultsData.getIOResultsExt().initProperties();
            }
            catch (UcodeSurveyException ucodeSurveyException) {
                if (2 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKF, "Exception caught loading properties file: " + ucodeSurveyException);
                }
                object = ucodeSurveyException.getArgs();
                this.showErrorMessageBox(ucodeSurveyException.getKey(), (Object[])object);
            }
            if (resourceList == null) {
                try {
                    this.doSurvey(this.resultsData.getReposLevel(), this.resultsData.getTargets());
                }
                catch (UcodeSurveyException ucodeSurveyException) {
                    if (1 <= Trace.LEVEL) {
                        Trace.trace(TRACE_MASKD, "IOSurveyResultsTasklet.service() UcodeSurveyException " + ucodeSurveyException);
                    }
                    return;
                }
                if (1 <= Trace.LEVEL) {
                    Trace.trace(TRACE_MASKD, "doSurvey Completed");
                }
            } else {
                this.resultsData.setResources(resourceList);
                this.resultsData.setSurveyResults(resourceList.getResourceList());
            }
            this.currentPanel = this.resultsPanelHandler;
            boolean bl = false;
            if (string.equals("true")) {
                bl = true;
            }
            this.clientData = new IOSurveyResultsClientData(this.resultsData.getReposLevel(), this.resultsData.getResources(), this.resultsData.getSurveyResults(), this.resultsData.getServiceLevel(), bl);
            object = this.resultsData.getProperty("backlevel");
            if (((String)object).equals("true")) {
                this.clientData.setBackLevel(true);
            } else {
                this.clientData.setBackLevel(false);
            }
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Launching IOSurveyResultsBean Bean");
            }
            IOSurveyResultsBean iOSurveyResultsBean = new IOSurveyResultsBean(this.clientData);
            iOSurveyResultsBean.setBeanName("IO Results Bean");
            panelTaskletResponse.replace("com.ibm.hsc.auiml.databeans.ucode.AutoSurveyPanel", "AutoSurveyResultsOverview", (PanelBean)iOSurveyResultsBean);
        } else {
            this.currentPanel.service(panelTaskletRequest, panelTaskletResponse, this);
        }
    }

    public void doSurvey(RepositoryItem repositoryItem, ArrayList arrayList) throws UcodeSurveyException {
        Object object;
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "-> IOSurveyResultsTasklet().doSurvey");
        }
        this.resultsData.setSurveyResults(null);
        try {
            object = new IOSurveyRunSurveyTask(this.resultsData);
            this.inSurveyFile = ((IOSurveyRunSurveyTask)object).runSurvey();
        }
        catch (UcodeSurveyException ucodeSurveyException) {
            // empty catch block
        }
        if (this.inSurveyFile == null || this.inSurveyFile[0] == null) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKF, "Survey File is null, exception/message should have been already done.");
            }
            this.showErrorMessageBox("0059");
            return;
        }
        object = new IOSurveyResultsUtils();
        ResourceList resourceList = ((IOSurveyResultsUtils)object).createResources(this.inSurveyFile, repositoryItem, this.resultsData);
        if (resourceList == null) {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "No resources have been found. ");
            }
            this.resultsData.setSurveyResults(null);
            this.resultsData.setResources(null);
        } else {
            this.resultsData.setResources(resourceList);
            this.resultsData.setSurveyResults(resourceList.getResourceList());
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKD, "Assigned resources to ResourcesList");
            }
        }
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<- IOSurveyResultsTasklet().doSurvey");
        }
    }

    public void load() {
    }

    public void save() {
    }

    public Capabilities getCapabilities() {
        return null;
    }

    public void showErrorMessageBox(String string) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-> showErrorMessageBox(" + string + ")");
        }
        this.showErrorMessageBox(string, null);
    }

    public void showErrorMessageBox(String string, Object[] objectArray) {
        if (1 <= Trace.LEVEL) {
            Trace.trace(TRACE_MASKT, "<-> showErrorMessageBox(" + string + "," + objectArray + ")");
        }
        this.showErrorMessageBox(new LocalizableText("com.ibm.hsc.common.bundles.UcodeBundle", "INFO_PANEL_TITLE"), new HSCLocalizableMsg(MsgType.ERROR_MESSAGE, "U", "com.ibm.hsc.common.bundles.UcodeBundleMessages", string, objectArray));
    }

    public void showErrorMessageBox(LocalizableText localizableText, HSCLocalizableMsg hSCLocalizableMsg) {
        block3: {
            if (1 <= Trace.LEVEL) {
                Trace.trace(TRACE_MASKT, "<-> showErrorMessageBox(" + localizableText + "," + (Object)((Object)hSCLocalizableMsg) + ")");
            }
            try {
                this.showMessageBox(true, localizableText, hSCLocalizableMsg);
            }
            catch (TaskletException taskletException) {
                if (Trace.LEVEL < 2) break block3;
                Trace.trace(TRACE_MASKF, "TaskletException while showing error message box: " + (Object)((Object)taskletException));
            }
        }
    }

    static interface PanelHandler {
        public void service(PanelTaskletRequest var1, PanelTaskletResponse var2, PanelTasklet var3) throws TaskletException;
    }
}

